<?php
/**
* @package		ui-TopStyle v1.0.3
* @author		Stephan W., http://www.3d-hobby-art.de
* @copyright	Copyright (C) Stephan W., http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');


$app			= JFactory::getApplication();
JHtml::addIncludePath(JPATH_THEMES . '/'.$app->getTemplate().'/html');

?>

<?php 
	if ($this->params->get('show_page_heading')) {
		echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
	}
 ?>

<?php

// init vars
$articles = '';

// leading articles
// featured_articles
$num_leading_articles = $this->params->get('num_leading_articles', 2);
$leading_articles 	 = array();
$i = 0;

foreach ($this->lead_items as $item) {
	$column = $i++ % $num_leading_articles;

	if (!isset($leading_articles[$column])) {
		$leading_articles[$column] = '';
	}

	$this->item = $item;
	$this->item->is_column = ($num_leading_articles > 1);
	$leading_articles[$column] .= $this->loadTemplate('item');
}

// render leading articles
if($config->get('featured_articles', 0)) {
	if (!empty($this->lead_items)) {
		if ($count = count($leading_articles)) {
			$articles  .= '<div class="tm-leading-article"><div class="uk-grid" data-uk-grid-match="">';
			for ($i = 0; $i < $count; $i++) {
				$articles .= '<div class="uk-width-small-1-1 uk-width-medium-1-'.$count.'">'.$leading_articles[$i].'</div>';
			}
			$articles  .= '</div></div>';
		}
	}
} else {
	if (!empty($this->lead_items)) {
		$articles  .= '<div class="uk-grid tm-leading-article" data-uk-grid-match=""><div class="uk-width-1-1">';
		foreach ($this->lead_items as $item) {
			$this->item = $item;
			$articles  .= $this->loadTemplate('item');
		}
		$articles  .= '</div></div>';
	}
}


// intro articles
$num_columns = $this->params->get('num_columns', 2);
$columns 	 = array();
$i = 0;

foreach ($this->intro_items as $item) {
	$column = $i++ % $num_columns;

	if (!isset($columns[$column])) {
		$columns[$column] = '';
	}

	$this->item = $item;
	$this->item->is_column_item = ($num_columns > 1);
	$columns[$column] .= $this->loadTemplate('item');
}

// render intro columns
if($config->get('featured_articles', 1)) {
	if ($count = count($columns)) {
		$articles  .= '<div class="uk-grid" data-uk-grid-match="">';
		for ($i = 0; $i < $count; $i++) {
			$articles .= '<div class="uk-width-medium-1-'.$count.'">'.$columns[$i].'</div>';
		}
		$articles  .= '</div>';
	}

} else {
	if ($count = count($columns)) {
		$articles  .= '<div class="tm-intro-article"><div class="uk-grid" data-uk-grid-match data-uk-grid-margin>';
		for ($i = 0; $i < $count; $i++) {
			$articles .= '<div class="uk-width-medium-1-'.$count.'">'.$columns[$i].'</div>';
		}
		$articles  .= '</div></div>';
	}
}

if ($articles) echo $articles;

?>

<?php if (!empty($this->link_items)) : ?>
<h3><?php echo JText::_('COM_CONTENT_MORE_ARTICLES'); ?></h3>
<ul class="uk-list uk-list-striped">
	<?php foreach ($this->link_items as &$item) : ?>
	<li><a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug)); ?>"><?php echo $item->title; ?></a></li>
	<?php endforeach; ?>
</ul>
<?php endif; ?>

<?php if (($this->params->def('show_pagination', 1) == 1  || ($this->params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>
<?php echo $this->pagination->getPagesLinks(); ?>
<?php endif; ?>