<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

/**
 * @version				1.0.3
 * @package				ui-TopStyle
 * @author / modify		Stephan W. http://www.3d-hobby-art.de/
 * @license				GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');
?>


<?php if ($config->get('featured_articles', 0)) { ?>
<!-- Theme Style "Featured Articles" K2 Layout -->

	<?php 
		if ($this->params->get('show_page_heading')) {
			echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
		}
	 ?>

	<?php if($this->params->get('catFeedIcon')): ?>
	<!-- RSS feed icon -->
	<div class="uk-text-right uk-margin-right">
		<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
	</div>
	<?php endif; ?>

	<?php if(isset($this->category) || ( $this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories) )): ?>
	<!-- Blocks for current category and subcategories -->
	<div class="uk-grid">

		<?php if(isset($this->category) && ( $this->params->get('catImage') || $this->params->get('catTitle') || $this->params->get('catDescription') || $this->category->event->K2CategoryDisplay )): ?>
		<!-- Category block -->
		<div class="uk-width-8-10 uk-container uk-container-center">
			<div class="uk-panel">
				<?php if(isset($this->addLink)): ?>
				<!-- Item add link -->
				<span class="catItemAddLink">
					<a data-k2-modal="edit" href="<?php echo $this->addLink; ?>">
						<?php echo JText::_('K2_ADD_A_NEW_ITEM_IN_THIS_CATEGORY'); ?>
					</a>
				</span>
				<?php endif; ?>

				<?php if($this->params->get('catImage') && $this->category->image): ?>
				<!-- Category image -->
				<img class="uk-align-left" alt="<?php echo K2HelperUtilities::cleanHtml($this->category->name); ?>" src="<?php echo $this->category->image; ?>" style="width:<?php echo $this->params->get('catImageWidth'); ?>px; height:auto;" />
				<?php endif; ?>

				<?php if($this->params->get('catTitle')): ?>
				<!-- Category title -->
				<h2><?php echo $this->category->name; ?>
				<?php if($this->params->get('catTitleItemCounter')): ?>
					<div class="uk-panel-badge uk-badge uk-badge-success"><?php echo ' ('.$this->pagination->total.')'; ?></div>
				<?php endif; ?>
				</h2>
				<?php endif; ?>

				<?php if($this->params->get('catDescription')): ?>
				<!-- Category description -->
				<div><?php echo $this->category->description; ?></div>
				<?php endif; ?>

				<!-- K2 Plugins: K2CategoryDisplay -->
				<?php echo $this->category->event->K2CategoryDisplay; ?>
			</div>
		</div>
		<?php endif; ?>

		<?php if($this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories)): ?>
		<!-- Subcategories -->
		<div class="itemListSubCategories">
			<h3><?php echo JText::_('K2_CHILDREN_CATEGORIES'); ?></h3>

			<?php foreach($this->subCategories as $key=>$subCategory): ?>

			<?php
			// Define a CSS class for the last container on each row
			if((($key+1)%($this->params->get('subCatColumns'))==0))
				$lastContainer= ' subCategoryContainerLast';
			else
				$lastContainer='';
			?>

			<div class="subCategoryContainer<?php echo $lastContainer; ?>"<?php echo (count($this->subCategories)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('subCatColumns'), 1).'%;"'; ?>>
				<div class="subCategory">
					<?php if($this->params->get('subCatImage') && $subCategory->image): ?>
					<!-- Subcategory image -->
					<a class="subCategoryImage" href="<?php echo $subCategory->link; ?>">
						<img alt="<?php echo K2HelperUtilities::cleanHtml($subCategory->name); ?>" src="<?php echo $subCategory->image; ?>" />
					</a>
					<?php endif; ?>

					<?php if($this->params->get('subCatTitle')): ?>
					<!-- Subcategory title -->
					<h2>
						<a href="<?php echo $subCategory->link; ?>">
							<?php echo $subCategory->name; ?><?php if($this->params->get('subCatTitleItemCounter')) echo ' ('.$subCategory->numOfItems.')'; ?>
						</a>
					</h2>
					<?php endif; ?>

					<?php if($this->params->get('subCatDescription')): ?>
					<!-- Subcategory description -->
					<div><?php echo $subCategory->description; ?></div>
					<?php endif; ?>

					<!-- Subcategory more... -->
					<a class="subCategoryMore" href="<?php echo $subCategory->link; ?>">
						<?php echo JText::_('K2_VIEW_ITEMS'); ?>
					</a>

					<div class="clr"></div>
				</div>
			</div>
			<?php if(($key+1)%($this->params->get('subCatColumns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

	</div>
	<?php endif; ?>


	<?php if((isset($this->leading) || isset($this->primary) || isset($this->secondary) || isset($this->links)) && (count($this->leading) || count($this->primary) || count($this->secondary) || count($this->links))): ?>

		<?php if(isset($this->leading) && count($this->leading)): ?>
		<!-- Leading items -->
			<div class="uk-grid uk-grid-match" data-uk-grid-match="{target:'.uk-article'}" data-uk-scrollspy="{cls:'uk-animation-fade', target:'.uk-article', delay:300}">
				<?php foreach($this->leading as $key=>$item): ?>
					<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_leading_columns') ?>">
						<div class="uk-position-relative">
							<article class="uk-article">
								<div class="<?php echo ($key%2) ? 'tm-mask-article-white' : 'tm-mask-article-grey'; ?>"></div>
								<?php
									// Load category_item.php by default
									$this->item = $item;
									echo $this->loadTemplate('item_featured_articles');
								?>
							</article>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>


		<?php if(isset($this->primary) && count($this->primary)): ?>
		<!-- Primary items -->
		<?php if(count($this->leading)): ?><hr class="uk-article-divider"><?php endif; ?>
		<div class="uk-grid uk-grid-match" data-uk-grid-match="{target:'.uk-article'}">
			<?php foreach($this->primary as $key=>$item): ?>
			<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_primary_columns') ?>">
					<div class="uk-position-relative">
						<article class="uk-article">
							<div class="<?php echo ($key%2) ? 'tm-mask-article-white' : 'tm-mask-article-grey'; ?>"></div>
							<?php
								// Load category_item.php by default
								$this->item = $item;
								echo $this->loadTemplate('item_featured_articles');
							?>
						</article>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>

		<?php if(isset($this->secondary) && count($this->secondary)): ?>
		<!-- Secondary items -->
		<div class="uk-grid uk-grid-match" data-uk-grid-match="{target:'.uk-article'}">
			<?php foreach($this->secondary as $key=>$item): ?>
				<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_secondary_columns') ?>">
						<div class="uk-position-relative">
							<article class="uk-article">
								<div class="<?php echo ($key%2) ? 'tm-mask-article-white' : 'tm-mask-article-grey'; ?>"></div>
								<?php
									// Load category_item.php by default
									$this->item = $item;
									echo $this->loadTemplate('item_featured_articles');
								?>
							</article>
						</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>

		<?php if(isset($this->links) && count($this->links)): ?>
		<!-- Link items -->
		<div id="itemListLinks">
			<h4><?php echo JText::_('K2_MORE'); ?></h4>
			<?php foreach($this->links as $key=>$item): ?>

			<?php
			// Define a CSS class for the last container on each row
			if((($key+1)%($this->params->get('num_links_columns'))==0) || count($this->links)<$this->params->get('num_links_columns'))
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>

				<?php
					// Load category_item.php by default
					$this->item = $item;
					echo $this->loadTemplate('item_featured_articles');
				?>

			<?php if(($key+1)%($this->params->get('num_links_columns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>


	<!-- Pagination -->
	<?php if($this->pagination->getPagesLinks()): ?>
		<?php if($this->params->get('catPagination')) echo $this->pagination->getPagesLinks(); ?>
		<?php if($this->params->get('catPaginationResults')): ?>
			<div class="uk-margin-left"><?php  echo $this->pagination->getPagesCounter(); ?></div>
		<?php endif; ?>
		
	<?php endif; ?>

	<?php endif; ?>



<?php } elseif ($config->get('article_timeline', 0)) { ?>
<?php ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// ?>
<!-- Timeline K2 Category Layout -->

	<?php 
		if ($this->params->get('show_page_heading')) {
			echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
		}
	 ?>

	<?php if($this->params->get('catFeedIcon')): ?>
	<!-- RSS feed icon -->
	<div class="uk-text-right uk-margin-right">
		<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
	</div>
	<?php endif; ?>

	<?php if(isset($this->category) || ( $this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories) )): ?>
	<!-- Blocks for current category and subcategories -->
	<div class="uk-grid">
		<?php if(isset($this->category) && ( $this->params->get('catImage') || $this->params->get('catTitle') || $this->params->get('catDescription') || $this->category->event->K2CategoryDisplay )): ?>
		<!-- Category block -->
		<div class="uk-width-8-10 uk-container uk-container-center">
			<div class="uk-panel">
				<?php if(isset($this->addLink)): ?>
				<!-- Item add link -->
				<span class="catItemAddLink">
					<a data-k2-modal="edit" href="<?php echo $this->addLink; ?>">
						<?php echo JText::_('K2_ADD_A_NEW_ITEM_IN_THIS_CATEGORY'); ?>
					</a>
				</span>
				<?php endif; ?>

				<?php if($this->params->get('catImage') && $this->category->image): ?>
				<!-- Category image -->
				<img class="uk-align-left" alt="<?php echo K2HelperUtilities::cleanHtml($this->category->name); ?>" src="<?php echo $this->category->image; ?>" style="width:<?php echo $this->params->get('catImageWidth'); ?>px; height:auto;" />
				<?php endif; ?>

				<?php if($this->params->get('catTitle')): ?>
				<!-- Category title -->
				<h2><?php echo $this->category->name; ?>
				<?php if($this->params->get('catTitleItemCounter')): ?>
					<div class="uk-panel-badge uk-badge uk-badge-success"><?php echo ' ('.$this->pagination->total.')'; ?></div>
				<?php endif; ?>
				</h2>
				<?php endif; ?>

				<?php if($this->params->get('catDescription')): ?>
				<!-- Category description -->
				<div><?php echo $this->category->description; ?></div>
				<?php endif; ?>

				<!-- K2 Plugins: K2CategoryDisplay -->
				<?php echo $this->category->event->K2CategoryDisplay; ?>
			</div>
		</div>
		<?php endif; ?>

		<?php if($this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories)): ?>
		<!-- Subcategories -->
		<div class="itemListSubCategories">
			<h3><?php echo JText::_('K2_CHILDREN_CATEGORIES'); ?></h3>

			<?php foreach($this->subCategories as $key=>$subCategory): ?>

			<?php
			// Define a CSS class for the last container on each row
			if((($key+1)%($this->params->get('subCatColumns'))==0))
				$lastContainer= ' subCategoryContainerLast';
			else
				$lastContainer='';
			?>

			<div class="subCategoryContainer<?php echo $lastContainer; ?>"<?php echo (count($this->subCategories)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('subCatColumns'), 1).'%;"'; ?>>
				<div class="subCategory">
					<?php if($this->params->get('subCatImage') && $subCategory->image): ?>
					<!-- Subcategory image -->
					<a class="subCategoryImage" href="<?php echo $subCategory->link; ?>">
						<img alt="<?php echo K2HelperUtilities::cleanHtml($subCategory->name); ?>" src="<?php echo $subCategory->image; ?>" />
					</a>
					<?php endif; ?>

					<?php if($this->params->get('subCatTitle')): ?>
					<!-- Subcategory title -->
					<h2>
						<a href="<?php echo $subCategory->link; ?>">
							<?php echo $subCategory->name; ?><?php if($this->params->get('subCatTitleItemCounter')) echo ' ('.$subCategory->numOfItems.')'; ?>
						</a>
					</h2>
					<?php endif; ?>

					<?php if($this->params->get('subCatDescription')): ?>
					<!-- Subcategory description -->
					<div><?php echo $subCategory->description; ?></div>
					<?php endif; ?>

					<!-- Subcategory more... -->
					<a class="subCategoryMore" href="<?php echo $subCategory->link; ?>">
						<?php echo JText::_('K2_VIEW_ITEMS'); ?>
					</a>

					<div class="clr"></div>
				</div>
			</div>
			<?php if(($key+1)%($this->params->get('subCatColumns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

	</div>
	<?php endif; ?>


	<div class="tm-timeline">
		<?php if(isset($this->leading) && count($this->leading)): ?>
		<!-- Leading items -->


				<?php foreach($this->leading as $key=>$item): ?>
					
						<article class="uk-article<?php echo ($key%2) ? ' tm-left' : ' tm-right'; ?> uk-width-small-1-1 uk-width-medium-1-2 uk-width-large-1-2">
								
								<?php
									// Load category_item.php by default
									$this->item = $item;
									echo $this->loadTemplate('item_timeline');
								?>
								
						</article>
					
				<?php endforeach; ?>


		<?php endif; ?>
	
	
	
	
	
	
	
	
	
	</div>


	<!-- Pagination -->
	<?php if(count($this->pagination->getPagesLinks())): ?>
	<div class="k2Pagination">
		<?php if($this->params->get('catPagination')) echo $this->pagination->getPagesLinks(); ?>
		<?php if($this->params->get('catPaginationResults')) echo $this->pagination->getPagesCounter(); ?>
	</div>
	<?php endif; ?>





<?php } else { ?>
<?php ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// ?>
<!-- Default K2 Category Layout -->
<!-- Start K2 Category Layout -->
<div id="k2Container" class="uk-panel itemListView<?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">
	<?php 
		if ($this->params->get('show_page_heading')) {
			echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
		}
	 ?>

	<?php if($this->params->get('catFeedIcon')): ?>
	<!-- RSS feed icon -->
	<div class="uk-text-right uk-margin-right">
		<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
	</div>
	<?php endif; ?>

	<?php if(isset($this->category) || ( $this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories) )): ?>
	<!-- Blocks for current category and subcategories -->
	<div class="uk-grid">

		<?php if(isset($this->category) && ( $this->params->get('catImage') || $this->params->get('catTitle') || $this->params->get('catDescription') || $this->category->event->K2CategoryDisplay )): ?>
		<!-- Category block -->
		<div class="uk-width-8-10 uk-container uk-container-center">
			<div class="uk-panel">
				<?php if(isset($this->addLink)): ?>
				<!-- Item add link -->
				<span class="catItemAddLink">
					<a class="modal" rel="{handler:'iframe',size:{x:990,y:650}}" href="<?php echo $this->addLink; ?>">
						<?php echo JText::_('K2_ADD_A_NEW_ITEM_IN_THIS_CATEGORY'); ?>
					</a>
				</span>
				<?php endif; ?>

				<?php if($this->params->get('catImage') && $this->category->image): ?>
				<!-- Category image -->
				<img class="uk-align-left" alt="<?php echo K2HelperUtilities::cleanHtml($this->category->name); ?>" src="<?php echo $this->category->image; ?>" style="width:<?php echo $this->params->get('catImageWidth'); ?>px; height:auto;" />
				<?php endif; ?>

				<?php if($this->params->get('catTitle')): ?>
				<!-- Category title -->
				<h2><?php echo $this->category->name; ?>
				<?php if($this->params->get('catTitleItemCounter')): ?>
					<div class="uk-panel-badge uk-badge uk-badge-success"><?php echo ' ('.$this->pagination->total.')'; ?></div>
				<?php endif; ?>
				</h2>
				<?php endif; ?>

				<?php if($this->params->get('catDescription')): ?>
				<!-- Category description -->
				<p><?php echo $this->category->description; ?></p>
				<?php endif; ?>

				<!-- K2 Plugins: K2CategoryDisplay -->
				<?php echo $this->category->event->K2CategoryDisplay; ?>

			</div>
		</div>
		<?php endif; ?>

		<?php if($this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories)): ?>
		<!-- Subcategories -->
		<div class="itemListSubCategories">
			<h3><?php echo JText::_('K2_CHILDREN_CATEGORIES'); ?></h3>

			<?php foreach($this->subCategories as $key=>$subCategory): ?>

			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('subCatColumns'))==0))
				$lastContainer= ' subCategoryContainerLast';
			else
				$lastContainer='';
			?>

			<div class="subCategoryContainer<?php echo $lastContainer; ?>"<?php echo (count($this->subCategories)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('subCatColumns'), 1).'%;"'; ?>>
				<div class="subCategory">
					<?php if($this->params->get('subCatImage') && $subCategory->image): ?>
					<!-- Subcategory image -->
					<a class="subCategoryImage" href="<?php echo $subCategory->link; ?>">
						<img alt="<?php echo K2HelperUtilities::cleanHtml($subCategory->name); ?>" src="<?php echo $subCategory->image; ?>" />
					</a>
					<?php endif; ?>

					<?php if($this->params->get('subCatTitle')): ?>
					<!-- Subcategory title -->
					<h2>
						<a href="<?php echo $subCategory->link; ?>">
							<?php echo $subCategory->name; ?><?php if($this->params->get('subCatTitleItemCounter')) echo ' ('.$subCategory->numOfItems.')'; ?>
						</a>
					</h2>
					<?php endif; ?>

					<?php if($this->params->get('subCatDescription')): ?>
					<!-- Subcategory description -->
					<p><?php echo $subCategory->description; ?></p>
					<?php endif; ?>

					<!-- Subcategory more... -->
					<a class="subCategoryMore" href="<?php echo $subCategory->link; ?>">
						<?php echo JText::_('K2_VIEW_ITEMS'); ?>
					</a>

					<div class="clr"></div>
				</div>
			</div>
			<?php if(($key+1)%($this->params->get('subCatColumns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

	</div>
	<?php endif; ?>



	<?php if((isset($this->leading) || isset($this->primary) || isset($this->secondary) || isset($this->links)) && (count($this->leading) || count($this->primary) || count($this->secondary) || count($this->links))): ?>

		<?php if(isset($this->leading) && count($this->leading)): ?>
		<!-- Leading items -->
		<div data-uk-scrollspy="{cls:'uk-animation-fade', target:'.uk-article', delay:350}">
			<div class="uk-grid uk-grid-small uk-grid-match" data-uk-grid-match="{target:'.uk-panel'}" data-uk-grid-margin>
				<?php foreach($this->leading as $key=>$item): ?>
					<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_leading_columns') ?>">
						<div class="uk-panel uk-panel-box">
								<?php
									// Load category_item.php by default
									$this->item = $item;
									echo $this->loadTemplate('item');
								?>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
		<?php endif; ?>

		<?php if(isset($this->primary) && count($this->primary)): ?>
		<!-- Primary items -->
		<?php if(count($this->leading)): ?><hr class="uk-article-divider"><?php endif; ?>
		<div class="uk-grid uk-grid-small uk-grid-match" data-uk-grid-match="{target:'.uk-panel'}" data-uk-grid-margin>
			<?php foreach($this->primary as $key=>$item): ?>
			<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_primary_columns') ?>">
					<div class="uk-panel uk-panel-box">
					<?php
						// Load category_item.php by default
						$this->item = $item;
						echo $this->loadTemplate('item');
					?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>

		<?php if(isset($this->secondary) && count($this->secondary)): ?>
		<!-- Secondary items -->
		<div class="uk-grid uk-grid-small uk-grid-match" data-uk-grid-match="{target:'.uk-panel'}" data-uk-grid-margin>
			<?php foreach($this->secondary as $key=>$item): ?>
			<div class="uk-width-small-1-1 uk-width-medium-1-<?php echo $this->params->get('num_secondary_columns') ?>">
					<div class="uk-panel uk-panel-box">
					<?php
						// Load category_item.php by default
						$this->item = $item;
						echo $this->loadTemplate('item');
					?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
		<?php endif; ?>

		<?php if(isset($this->links) && count($this->links)): ?>
		<!-- Link items -->
		<div id="uk-panel uk-panel-box">
			<h4><?php echo JText::_('K2_MORE'); ?></h4>
			<?php foreach($this->links as $key=>$item): ?>

			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('num_links_columns'))==0) || count($this->links)<$this->params->get('num_links_columns') )
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>

			<div class="itemContainer<?php echo $lastContainer; ?>"<?php echo (count($this->links)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('num_links_columns'), 1).'%;"'; ?>>
				<?php
					// Load category_item_links.php by default
					$this->item=$item;
					echo $this->loadTemplate('item_links');
				?>
			</div>
			<?php if(($key+1)%($this->params->get('num_links_columns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

	<!-- Pagination -->
	<?php if(count($this->pagination->getPagesLinks())): ?>
	<div class="k2Pagination">
		<?php if($this->params->get('catPagination')) echo $this->pagination->getPagesLinks(); ?>
		<div class="clr"></div>
		<?php if($this->params->get('catPaginationResults')) echo $this->pagination->getPagesCounter(); ?>
	</div>
	<?php endif; ?>

	<?php endif; ?>
</div>
<!-- End K2 Category Layout -->

<?php } ?>