<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;
/**
 * @version				1.0.1
 * @package				ui-TopStyle
 * @author / modify		Stephan W. http://www.3d-hobby-art.de/
 * @license				GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */
?>

<!-- Comments Form -->
<form action="<?php echo JURI::root(true); ?>/index.php" method="post" id="comment-form" class="uk-form uk-margin uk-form-horizontal form-validate">

	<fieldset data-uk-margin>
		<legend><?php echo JText::_('K2_LEAVE_A_COMMENT') ?></legend>
		
		<?php if($this->params->get('commentsFormNotes')): ?>
		<p>
			<?php if($this->params->get('commentsFormNotesText')): ?>
			<?php echo nl2br($this->params->get('commentsFormNotesText')); ?>
			<?php else: ?>
			<?php echo JText::_('K2_COMMENT_FORM_NOTES') ?>
			<?php endif; ?>
		</p>
		<?php endif; ?>
		
		<div class="uk-form-row">
			<label class="uk-form-label" for="commentText"><?php echo JText::_('K2_MESSAGE'); ?> <span class="uk-text-danger">*</span></label>
			<div class="uk-form-controls"><textarea rows="5" class="inputbox uk-width-medium-2-3" onblur="if(this.value=='') this.value='<?php echo JText::_('K2_ENTER_YOUR_MESSAGE_HERE'); ?>';" onfocus="if(this.value=='<?php echo JText::_('K2_ENTER_YOUR_MESSAGE_HERE'); ?>') this.value='';" name="commentText" id="commentText"><?php echo JText::_('K2_ENTER_YOUR_MESSAGE_HERE'); ?></textarea></div>
		</div>
		
		<div class="uk-form-row">
			<label class="uk-form-label" for="userName"><?php echo JText::_('K2_NAME'); ?> <span class="uk-text-danger">*</span></label>
			<div class="uk-form-controls"><input class="inputbox uk-width-medium-2-3" type="text" name="userName" id="userName" value="<?php echo JText::_('K2_ENTER_YOUR_NAME'); ?>" onblur="if(this.value=='') this.value='<?php echo JText::_('K2_ENTER_YOUR_NAME'); ?>';" onfocus="if(this.value=='<?php echo JText::_('K2_ENTER_YOUR_NAME'); ?>') this.value='';" /></div>
		</div>
		
		<div class="uk-form-row">
			<label class="uk-form-label" for="commentEmail"><?php echo JText::_('K2_EMAIL'); ?> <span class="uk-text-danger">*</span></label>
			<div class="uk-form-controls"><input class="inputbox uk-width-medium-2-3" type="text" name="commentEmail" id="commentEmail" value="<?php echo JText::_('K2_ENTER_YOUR_EMAIL_ADDRESS'); ?>" onblur="if(this.value=='') this.value='<?php echo JText::_('K2_ENTER_YOUR_EMAIL_ADDRESS'); ?>';" onfocus="if(this.value=='<?php echo JText::_('K2_ENTER_YOUR_EMAIL_ADDRESS'); ?>') this.value='';" /></div>
		</div>
		
		<div class="uk-form-row">
			<label class="uk-form-label" for="commentURL"><?php echo JText::_('K2_WEBSITE_URL'); ?></label>
			<div class="uk-form-controls"><input class="inputbox uk-width-medium-2-3" type="text" name="commentURL" id="commentURL" value="<?php echo JText::_('K2_ENTER_YOUR_SITE_URL'); ?>"  onblur="if(this.value=='') this.value='<?php echo JText::_('K2_ENTER_YOUR_SITE_URL'); ?>';" onfocus="if(this.value=='<?php echo JText::_('K2_ENTER_YOUR_SITE_URL'); ?>') this.value='';" /></div>
		</div>
		
		<?php if($this->params->get('recaptcha') && ($this->user->guest || $this->params->get('recaptchaForRegistered', 1))): ?>
		<div class="uk-form-row">
		<?php if(!$this->params->get('recaptchaV2')): ?>		
			<label class="uk-form-label"><?php echo JText::_('K2_ENTER_THE_TWO_WORDS_YOU_SEE_BELOW'); ?></label>
			<?php endif; ?>
			<div class="uk-form-controls"><div id="recaptcha" class="<?php echo $this->recaptchaClass; ?>"></div></div>
		</div>
		<?php endif; ?>
		
		<div class="uk-form-row">
			<div class="uk-form-controls"><input type="submit" class="uk-button uk-margin-top" id="submitCommentButton" value="<?php echo JText::_('K2_SUBMIT_COMMENT'); ?>" /></div>
		</div>


		<div id="formLog" class="uk-alert uk-alert-danger uk-text-center" data-uk-alert>
		</div>

		<input type="hidden" name="option" value="com_k2" />
		<input type="hidden" name="view" value="item" />
		<input type="hidden" name="task" value="comment" />
		<input type="hidden" name="itemID" value="<?php echo JRequest::getInt('id'); ?>" />
		<?php echo JHTML::_('form.token'); ?>
	
	</fieldset>
</form>