<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

/**
 * @version				1.0.3
 * @package				ui-TopStyle
 * @author / modify		Stephan W. http://www.3d-hobby-art.de/
 * @license				GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');
?>

<?php 
	if ($this->params->get('show_page_heading')) {
		echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
	}
 ?>

		<?php foreach($this->blocks as $key=>$block): ?>
	<div class="uk-grid" data-uk-margin>
		<div class="uk-width-1-1" >

			<?php if($this->source=='categories'): $category=$block; ?>

			<?php if($this->params->get('categoryFeed') || $this->params->get('categoryImage') || $this->params->get('categoryTitle') || $this->params->get('categoryDescription')): ?>
			<!-- Start K2 Category block -->
			<div class="latestItemsCategory">
			
				<?php if($this->params->get('categoryFeed')): ?>
					<!-- RSS feed icon -->
					<div class="uk-text-right uk-margin-right">
						<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
					</div>
				<?php endif; ?>

				<?php if ($this->params->get('categoryImage') && !empty($category->image)): ?>
				<div class="latestItemsCategoryImage">
					<img src="<?php echo $category->image; ?>" alt="<?php echo K2HelperUtilities::cleanHtml($category->name); ?>" style="width:<?php echo $this->params->get('catImageWidth'); ?>px;height:auto;" />
				</div>
				<?php endif; ?>

				<?php if ($this->params->get('categoryTitle')): ?>
				<h2><a href="<?php echo $category->link; ?>"><?php echo $category->name; ?></a></h2>
				<?php endif; ?>

				<?php if ($this->params->get('categoryDescription') && isset($category->description)): ?>
				<p><?php echo $category->description; ?></p>
				<?php endif; ?>

				<div class="clr"></div>

				<!-- K2 Plugins: K2CategoryDisplay -->
				<?php echo $category->event->K2CategoryDisplay; ?>
				<div class="clr"></div>
			</div>
			<!-- End K2 Category block -->
			<?php endif; ?>

			<?php else: $user=$block; ?>

			<?php if ($this->params->get('userFeed') || $this->params->get('userImage') || $this->params->get('userName') || $this->params->get('userDescription') || $this->params->get('userURL') || $this->params->get('userEmail')): ?>
				<!-- Start K2 User block -->
				<div class="uk-panel-box uk-margin-bottom">
					<div class="uk-grid uk-flex-middle" data-uk-grid-margin>

						<?php if ($this->params->get('userImage') && !empty($user->avatar)): ?>
						<div class="uk-width-medium-2-10">
							<div class="uk-panel">
								<img class="uk-thumbnail" src="<?php echo $user->avatar; ?>" alt="<?php echo $user->name; ?>" style="width:<?php echo $this->params->get('userImageWidth'); ?>px;height:auto;" />
							</div>
						</div>
						<?php endif; ?>
							
						<div class="uk-width-medium-8-10 uk-flex-top">

							<?php if($this->params->get('userFeed')): ?>
								<!-- RSS feed icon -->
								<div class="uk-align-right">
									<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
								</div>
							<?php endif; ?>

							<?php if ($this->params->get('userName')): ?>
								<h3><a rel="author" href="<?php echo $user->link; ?>"><?php echo $user->name; ?></a></h3>
							<?php endif; ?>

							<?php if ($this->params->get('userDescription') && isset($user->profile->description)): ?>
								<p class="latestItemsUserDescription"><?php echo $user->profile->description; ?></p>
							<?php endif; ?>

							<?php if ($this->params->get('userURL') || $this->params->get('userEmail')): ?>
								<p class="latestItemsUserAdditionalInfo">
									<?php if ($this->params->get('userURL') && isset($user->profile->url)): ?>
										<span class="latestItemsUserURL">
											<i class="uk-icon-link"></i> <a rel="me" href="<?php echo $user->profile->url; ?>" target="_blank"><?php echo $user->profile->url; ?></a>
										</span>
									<?php endif; ?>

									<?php if ($this->params->get('userEmail')): ?>
									<?php if ($this->params->get('userURL') && isset($user->profile->url)) echo '|'; ?>
									<span class="latestItemsUserEmail">
										<i class="uk-icon-envelope"></i> <?php echo JHTML::_('Email.cloak', $user->email); ?>
									</span>
									<?php endif; ?>
								</p>
							<?php endif; ?>

						</div>

							<?php echo $user->event->K2UserDisplay; ?>

							<div class="clr"></div>

					</div>
				</div>
				<!-- End K2 User block -->
			<?php endif; ?>

			<?php endif; ?>

			<!-- Start Items list -->
			<ul class="uk-grid uk-grid-small uk-grid-width-1-2 uk-grid-width-medium-1-<?php echo $this->params->get('latestItemsCols') ?>" data-uk-grid-margin>
				<?php if($this->params->get('latestItemsDisplayEffect')=="first"): ?>

				<?php foreach ($block->items as $itemCounter=>$item): K2HelperUtilities::setDefaultImage($item, 'latest', $this->params); ?>
				
				<?php if($itemCounter==0): ?>
				<?php $this->item=$item; echo $this->loadTemplate('item'); ?>
				<?php else: ?>
				<h2 class="latestItemTitleList">
					<?php if ($item->params->get('latestItemTitleLinked')): ?>
					<a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
					<?php else: ?>
					<?php echo $item->title; ?>
					<?php endif; ?>
				</h2>
				<?php endif; ?>
				<?php endforeach; ?>

				<?php else: ?>

				<?php foreach ($block->items as $item): K2HelperUtilities::setDefaultImage($item, 'latest', $this->params); ?>
				<?php $this->item=$item; echo $this->loadTemplate('item'); ?>
				<?php endforeach; ?>

				<?php endif; ?>
			</div>
		</div>
			<!-- End Item list -->



		<?php if(($key+1)%($this->params->get('latestItemsCols'))==0): ?>
		<div class="clr"></div>
		<?php endif; ?>

		<?php endforeach; ?>