<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

/**
 * @version				1.0.1
 * @package				ui-TopStyle
 * @author / modify		Stephan W. http://www.3d-hobby-art.de/
 * @license				GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

?>


<li>
	<div class="uk-panel uk-panel-box tm-latestItemView">
		
		<?php if($this->item->params->get('latestItemImage') && !empty($this->item->image)): ?>
			<!-- Item Image -->
			<div class="uk-panel-teaser">
				<a href="<?php echo $this->item->link; ?>" title="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>">
					<img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" style="width:<?php echo $this->item->imageWidth; ?>px;height:auto;" />
				</a>
				
				<?php if($this->item->params->get('itemImageMainCaption') && !empty($this->item->image_caption) || $this->item->params->get('itemImageMainCredits') && !empty($this->item->image_credits)): ?>
					<div class="uk-thumbnail-caption">

					<?php if($this->item->params->get('itemImageMainCaption') && !empty($this->item->image_caption)): ?>
					<!-- Image caption -->
						<span class="itemImageCaption"><?php echo $this->item->image_caption; ?></span>
					<?php endif; ?>

					<?php if($this->item->params->get('itemImageMainCredits') && !empty($this->item->image_credits)): ?>
					<!-- Image credits -->
						<p class="itemImageCredits"><?php echo $this->item->image_credits; ?></p>
					<?php endif; ?>

					</div>
				<?php endif; ?>
				
			</div>
		<?php endif; ?>
		
		<article class="uk-article">
			<!-- Plugins: BeforeDisplay -->
			<?php echo $this->item->event->BeforeDisplay; ?>

			<!-- K2 Plugins: K2BeforeDisplay -->
			<?php echo $this->item->event->K2BeforeDisplay; ?>


			<?php if($this->item->params->get('latestItemTitle')): ?>
				<!-- Item title -->
				<h3 class="uk-panel-title">
				<?php if ($this->item->params->get('latestItemTitleLinked')): ?>
					<a href="<?php echo $this->item->link; ?>">
						<?php echo $this->item->title; ?>
					</a>
				<?php else: ?>
					<?php echo $this->item->title; ?>
				<?php endif; ?>
				</h3>
			<?php endif; ?>

			<?php if($this->item->params->get('latestItemDateCreated')): ?>
			<!-- Date created -->
			<p class="uk-article-meta">
				<?php echo JHTML::_('date', $this->item->created , JText::_('K2_DATE_FORMAT_LC2')); ?>
			</p>
			<?php endif; ?>

		  <!-- Plugins: AfterDisplayTitle -->
		  <?php echo $this->item->event->AfterDisplayTitle; ?>

		  <!-- K2 Plugins: K2AfterDisplayTitle -->
		  <?php echo $this->item->event->K2AfterDisplayTitle; ?>

		  <div class="latestItemBody">

			  <!-- Plugins: BeforeDisplayContent -->
			  <?php echo $this->item->event->BeforeDisplayContent; ?>

			  <!-- K2 Plugins: K2BeforeDisplayContent -->
			  <?php echo $this->item->event->K2BeforeDisplayContent; ?>



			  <?php if($this->item->params->get('latestItemIntroText')): ?>
			  <!-- Item introtext -->
			  <div class="uk-article-lead">
				<?php echo $this->item->introtext; ?>
			  </div>
			  <?php endif; ?>


			  <!-- Plugins: AfterDisplayContent -->
			  <?php echo $this->item->event->AfterDisplayContent; ?>

			  <!-- K2 Plugins: K2AfterDisplayContent -->
			  <?php echo $this->item->event->K2AfterDisplayContent; ?>

			  <div class="clr"></div>
		  </div>

		  <?php if($this->item->params->get('latestItemCategory') || $this->item->params->get('latestItemTags')): ?>
		  <div class="latestItemLinks">

				<?php if($this->item->params->get('latestItemCategory')): ?>
				<!-- Item category name -->
				<p class="uk-article-meta">
					<span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span>
					<a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
				</p>
				<?php endif; ?>

				<?php if($this->item->params->get('latestItemTags') && count($this->item->tags)): ?>
					<!-- Item tags -->
					<div class="uk-margin uk-margin-small-top">
						<ul class="uk-subnav uk-subnav-line tm-itemTags-k2">
							<li><i class="uk-icon-tags"></i></li>
							<?php foreach ($this->item->tags as $tag): ?>
							<li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
							<?php endforeach; ?>
						</ul>
					</div>
				<?php endif; ?>

		  </div>
		  <?php endif; ?>

			<div class="clr"></div>

		  <?php if($this->params->get('latestItemVideo') && !empty($this->item->video)): ?>
		  <!-- Item video -->
		  <div class="latestItemVideoBlock">
			<h3><?php echo JText::_('K2_RELATED_VIDEO'); ?></h3>
			  <span class="latestItemVideo<?php if($this->item->videoType=='embedded'): ?> embedded<?php endif; ?>"><?php echo $this->item->video; ?></span>
		  </div>
		  <?php endif; ?>

			<?php if($this->item->params->get('latestItemCommentsAnchor') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1')) ): ?>
			<!-- Anchor link to comments below -->
			<div class="latestItemCommentsLink">
				<?php if(!empty($this->item->event->K2CommentsCounter)): ?>
					<!-- K2 Plugins: K2CommentsCounter -->
					<?php echo $this->item->event->K2CommentsCounter; ?>
				<?php else: ?>
					<?php if($this->item->numOfComments > 0): ?>
					<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
						<?php echo $this->item->numOfComments; ?> <?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?>
					</a>
					<?php else: ?>
					<a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
						<?php echo JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?>
					</a>
					<?php endif; ?>
				<?php endif; ?>
			</div>
			<?php endif; ?>

			<?php if ($this->item->params->get('latestItemReadMore')): ?>
			<!-- Item "read more..." link -->
			<div class="uk-text-center">
				<a class="uk-button" href="<?php echo $this->item->link; ?>">
					<?php echo JText::_('K2_READ_MORE'); ?>
				</a>
			</div>
			<?php endif; ?>

		  <!-- Plugins: AfterDisplay -->
		  <?php echo $this->item->event->AfterDisplay; ?>

		  <!-- K2 Plugins: K2AfterDisplay -->
		  <?php echo $this->item->event->K2AfterDisplay; ?>
		
		</article>
	</div>

</li>
<!-- End K2 Item Layout -->