<?php
/**
 * @version    2.7.x
 * @package    K2
 * @author     JoomlaWorks http://www.joomlaworks.net
 * @copyright  Copyright (c) 2006 - 2016 JoomlaWorks Ltd. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

/**
 * @version				1.0.1
 * @package				ui-TopStyle
 * @author / modify		Stephan W. http://www.3d-hobby-art.de/
 * @license				GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');
?>

<!-- Start K2 Tag Layout -->
<div id="k2Container" class="tm-tagView<?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">


	<?php 
		if ($this->params->get('show_page_heading')) {
			echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
		}
	 ?>


	<?php if($this->params->get('tagFeedIcon',1)): ?>
		<!-- RSS feed icon -->
		<div class="uk-text-right uk-margin-right">
			<a class="uk-icon-rss" href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
		</div>
	<?php endif; ?>

<?php if(count($this->items)): ?>

	<?php foreach($this->items as $item): ?>
	<div class="uk-block uk-block-muted">
		<div class="uk-container">
			<div class="uk-grid" data-uk-grid-margin>
				<!-- Start K2 Item Layout -->
				<div class="uk-width-medium-1-3">
					<div class="uk-panel">
						<?php if($item->params->get('tagItemImage',1) && !empty($item->imageGeneric)): ?>
							<!-- Item Image -->
							<div class="uk-margin-small-bottom tm-tagItemImageBlock">
								<span class="tagItemImage">
									<a href="<?php echo $item->link; ?>" title="<?php if(!empty($item->image_caption)) echo K2HelperUtilities::cleanHtml($item->image_caption); else echo K2HelperUtilities::cleanHtml($item->title); ?>">
										<img src="<?php echo $item->imageGeneric; ?>" alt="<?php if(!empty($item->image_caption)) echo K2HelperUtilities::cleanHtml($item->image_caption); else echo K2HelperUtilities::cleanHtml($item->title); ?>" style="width:<?php echo $item->params->get('itemImageGeneric'); ?>px; height:auto;" />
									</a>
								</span>
							</div>
						<?php endif; ?>

						<?php if($item->params->get('tagItemDateCreated',1)): ?>
							<!-- Date created -->
							<span class="uk-article-meta">
								<?php echo JHTML::_('date', $item->created , JText::_('K2_DATE_FORMAT_LC2')); ?>
							</span>
						<?php endif; ?>
					</div>
				</div>

				<div class="uk-width-medium-2-3">

					<?php if($item->params->get('tagItemTitle',1)): ?>
						<!-- Item title -->
						<h2 class="tagItemTitle">
							<?php if ($item->params->get('tagItemTitleLinked',1)): ?>
							<a href="<?php echo $item->link; ?>">
								<?php echo $item->title; ?>
							</a>
							<?php else: ?>
								<?php echo $item->title; ?>
							<?php endif; ?>
						</h2>
					<?php endif; ?>

					<div class="tagItemBody">
						<?php if($item->params->get('tagItemIntroText',1)): ?>
						<!-- Item introtext -->
						<div class="tagItemIntroText">
							<?php echo $item->introtext; ?>
						</div>
						<?php endif; ?>
					</div>

					<?php if($item->params->get('tagItemExtraFields',0) && count($item->extra_fields)): ?>
					<!-- Item extra fields -->
					<div class="tagItemExtraFields">
					<h4><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h4>
					<ul>
					<?php foreach ($item->extra_fields as $key=>$extraField): ?>
					<?php if($extraField->value != ''): ?>
					<li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
					<?php if($extraField->type == 'header'): ?>
					<h4 class="tagItemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
					<?php else: ?>
					<span class="tagItemExtraFieldsLabel"><?php echo $extraField->name; ?></span>
					<span class="tagItemExtraFieldsValue"><?php echo $extraField->value; ?></span>
					<?php endif; ?>
					</li>
					<?php endif; ?>
					<?php endforeach; ?>
					</ul>
					<div class="clr"></div>
					</div>
					<?php endif; ?>

					<?php if($item->params->get('tagItemCategory')): ?>
					<!-- Item category name -->
					<div class="uk-article-meta uk-margin-bottom tm-tagItemCategory">
					<span><?php echo JText::_('K2_PUBLISHED_IN'); ?></span>
					<a href="<?php echo $item->category->link; ?>"><?php echo $item->category->name; ?></a>
					</div>
					<?php endif; ?>

					<?php if ($item->params->get('tagItemReadMore')): ?>
						<!-- Item "read more..." link -->
						<div class="uk-margin-small-top tm-tagItemReadMore">
							<a class="uk-button" href="<?php echo $item->link; ?>">
								<?php echo JText::_('K2_READ_MORE'); ?>
							</a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
	<?php endforeach; ?>


<!-- Pagination -->
<?php if($this->pagination->getPagesLinks()): ?>
	<div class="k2Pagination">
		<?php echo $this->pagination->getPagesLinks(); ?>
		<div class="clr"></div>
		<?php echo $this->pagination->getPagesCounter(); ?>
	</div>
<?php endif; ?>

<?php endif; ?>

</div>