<?php
/**
* @package		ui-TopStyle
* @author		Stephan W., http://www.3d-hobby-art.de
* @copyright	Copyright (C) Stephan W., http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');


JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');
$isSingleTag = (count($this->item) == 1);
?>

<?php 
	if ($this->params->get('show_page_heading')) {
		echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
	}
 ?>

<?php if($this->params->get('show_tag_title', 1)) : ?>
<h2>
	<?php echo JHtml::_('content.prepare', $this->document->title, '', 'com_tag.tag'); ?>
</h2>
<?php endif; ?>

<?php // We only show a tag description if there is a single tag. ?>
<?php  if (count($this->item) == 1 && (($this->params->get('tag_list_show_tag_image', 1)) || $this->params->get('tag_list_show_tag_description', 1))) : ?>
	<div class="uk-clearfix uk-margin">
	<?php $images = json_decode($this->item[0]->images); ?>
	<?php if ($this->params->get('tag_list_show_tag_image', 1) == 1 && !empty($images->image_fulltext)) : ?>
		<img src="<?php echo htmlspecialchars($images->image_fulltext);?>">
	<?php endif; ?>
	<?php if ($this->params->get('tag_list_show_tag_description') == 1 && $this->item[0]->description) : ?>
		<?php echo JHtml::_('content.prepare', $this->item[0]->description, '', 'com_tags.tag'); ?>
	<?php endif; ?>
	</div>
<?php endif; ?>
<?php // If there are multiple tags and a description or image has been supplied use that. ?>
<?php if ($this->params->get('tag_list_show_tag_description', 1) || $this->params->get('show_description_image', 1)): ?>
	<?php if ($this->params->get('show_description_image', 1) == 1 && $this->params->get('tag_list_image')) :?>
		<img src="<?php echo $this->params->get('tag_list_image');?>">
	<?php endif; ?>
	<?php if ($this->params->get('tag_list_description', '') > '') :?>
		<?php echo JHtml::_('content.prepare', $this->params->get('tag_list_description'), '', 'com_tags.tag'); ?>
	<?php endif; ?>
<?php endif; ?>

<?php echo $this->loadTemplate('items'); ?>