<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_users
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// include config and layout
$base = dirname(dirname(dirname(__FILE__)));
include($base.'/config.php');

// JHtml::_('behavior.keepalive');
JHtml::_('behavior.formvalidator');
?>
<div class="reset<?php echo $this->pageclass_sfx?>">
	<?php 
		if ($this->params->get('show_page_heading')) {
			echo '<header class="page-header"><div class="uk-container"><h1>'.$this->escape($this->params->get('page_heading')).'</h1></div></header>';
		}
	?>

	<form id="user-registration" action="<?php echo JRoute::_('index.php?option=com_users&task=reset.request'); ?>" method="post" class="uk-form uk-form-horizontal">
		<?php foreach ($this->form->getFieldsets() as $fieldset) : ?>
			<fieldset data-uk-margin>
				<p><?php echo JText::_($fieldset->label); ?></p>
				<?php foreach ($this->form->getFieldset($fieldset->name) as $name => $field) : ?>
				<div class="uk-form-row">
					<?php echo $field->label; ?>
					<div class="uk-form-controls">
						<?php echo $field->input; ?>
					</div>
				</div>
				<?php endforeach; ?>
			</fieldset>
		<?php endforeach; ?>

		<div class="uk-form-row">
			<div class="uk-form-controls">
				<button type="submit" class="uk-button uk-button-primary validate"><?php echo JText::_('JSUBMIT'); ?></button>
			</div>
		</div>
		<?php echo JHtml::_('form.token'); ?>
	</form>
</div>
