<?php
/**
 * @version		$Id: comments.php 1812 2013-01-14 18:45:06Z lefteris.kavadas $
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

?>

<div id="k2ModuleBox<?php echo $module->id; ?>" class="k2LatestCommentsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">

	<?php if(count($comments)): ?>
	<ul class="uk-list">
		<?php foreach ($comments as $key=>$comment):	?>
		<li class="<?php echo ($key%2) ? "odd" : "even"; if(count($comments)==$key+1) echo ' lastItem'; ?>">

			<?php if($comment->userImage) { ?>
			<div class="uk-grid uk-flex-top" data-uk-grid-margin="">
				<div class="uk-width-medium-1-3">
					<div class="uk-panel">
						<a class="k2Avatar lcAvatar" href="<?php echo $comment->link; ?>" data-uk-tooltip title="<?php echo JFilterOutput::cleanText($comment->userName); ?>">
							<img src="<?php echo $comment->userImage; ?>" alt="<?php echo JFilterOutput::cleanText($comment->userName); ?>" style="width:<?php echo $lcAvatarWidth; ?>px;height:auto;-webkit-border-radius:<?php echo $lcAvatarWidth; ?>px; border-radius:<?php echo $lcAvatarWidth; ?>px;" />
						</a>
					</div>
				</div>
				<div class="uk-width-medium-2-3 uk-flex-top">
					<?php if($params->get('commentLink')): ?>
						<p><a href="<?php echo $comment->link; ?>"><span class="lcComment"><?php echo $comment->commentText; ?></span></a></p>
					<?php else: ?>
						<p class="lcComment"><?php echo $comment->commentText; ?></p>
					<?php endif; ?>

					<?php if($params->get('commenterName')): ?>
						<p class="uk-text-small tm-lcUsername"><?php echo JText::_('K2_WRITTEN_BY'); ?>
							<?php if(isset($comment->userLink)): ?>
							<a rel="author" href="<?php echo $comment->userLink; ?>"><?php echo $comment->userName; ?></a>
							<?php elseif($comment->commentURL): ?>
							<a target="_blank" rel="nofollow" href="<?php echo $comment->commentURL; ?>"><?php echo $comment->userName; ?></a>
							<?php else: ?>
							<?php echo $comment->userName; ?>
							<?php endif; ?>
						</p>
					<?php endif; ?>
				</div>
			</div>
			
			<div class="uk-grid" data-uk-grid-margin>
				<div class="uk-width-1-1">
					<div class="uk-panel">
						<?php if($params->get('commentDate')): ?>
							<span class="uk-text-small tm-lcCommentDate">
								<?php if($params->get('commentDateFormat') == 'relative'): ?>
								<?php echo $comment->commentDate; ?>
								<?php else: ?>
								<?php // echo JText::_('K2_ON'); ?> <?php echo JHTML::_('date', $comment->commentDate, JText::_('K2_DATE_FORMAT_LC2')); ?>
								<?php endif; ?>
							</span>
						<?php endif; ?>
						
						<?php if($params->get('itemTitle')): ?>
							<span class="uk-article-meta tm-lcItemTitle"><a href="<?php echo $comment->itemLink; ?>"><?php echo $comment->title; ?></a></span>
						<?php endif; ?>

						<?php if($params->get('itemCategory')): ?>
							<span class="uk-article-meta tm-lcItemCategory">(<a href="<?php echo $comment->catLink; ?>"><?php echo $comment->categoryname; ?></a>)</span>
						<?php endif; ?>
					</div>
				</div>
			</div>
			
			<?php } else { ?>
			
			<div class="uk-grid" data-uk-grid-margin>
				<div class="uk-width-1-1">
					<div class="uk-panel">

						<?php if($params->get('commentLink')): ?>
							<p><a href="<?php echo $comment->link; ?>"><span class="lcComment"><?php echo $comment->commentText; ?></span></a></p>
						<?php else: ?>
							<p class="lcComment"><?php echo $comment->commentText; ?></p>
						<?php endif; ?>

						<?php if($params->get('commenterName')): ?>
							<p class="uk-text-small tm-lcUsername"><?php echo JText::_('K2_WRITTEN_BY'); ?>
								<?php if(isset($comment->userLink)): ?>
								<a rel="author" href="<?php echo $comment->userLink; ?>"><?php echo $comment->userName; ?></a>
								<?php elseif($comment->commentURL): ?>
								<a target="_blank" rel="nofollow" href="<?php echo $comment->commentURL; ?>"><?php echo $comment->userName; ?></a>
								<?php else: ?>
								<?php echo $comment->userName; ?>
								<?php endif; ?>
							</p>
						<?php endif; ?>
					
						<?php if($params->get('commentDate')): ?>
							<span class="uk-text-small tm-lcCommentDate">
								<?php if($params->get('commentDateFormat') == 'relative'): ?>
								<?php echo $comment->commentDate; ?>
								<?php else: ?>
								<?php // echo JText::_('K2_ON'); ?> <?php echo JHTML::_('date', $comment->commentDate, JText::_('K2_DATE_FORMAT_LC2')); ?>
								<?php endif; ?>
							</span>
						<?php endif; ?>
						
						<?php if($params->get('itemTitle')): ?>
							<span class="uk-article-meta tm-lcItemTitle"><a href="<?php echo $comment->itemLink; ?>"><?php echo $comment->title; ?></a></span>
						<?php endif; ?>

						<?php if($params->get('itemCategory')): ?>
							<span class="uk-article-meta tm-lcItemCategory">(<a href="<?php echo $comment->catLink; ?>"><?php echo $comment->categoryname; ?></a>)</span>
						<?php endif; ?>
					</div>
				</div>
			</div>

			<?php } ?>
		</li>
		<?php endforeach; ?>
	</ul>
	<?php endif; ?>

	<?php if($params->get('feed')): ?>
		<!-- RSS feed icon -->
		<div class="uk-text-right uk-margin-right">
			<a class="uk-icon-rss" href="<?php echo JRoute::_('index.php?option=com_k2&view=itemlist&format=feed&moduleID='.$module->id); ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>" data-uk-tooltip></a>
		</div>
	<?php endif; ?>

</div>
