<?php
/**
* @package		ui-TopStyle v1.0.5
* @author		Stephan W., http://www.3d-hobby-art.de
* @copyright	Copyright (C) Stephan W., http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/


/*
 * Generate 3-column layout
 */
$config          = $this['config'];
$sidebars        = $config->get('sidebars', array());
$columns         = array('main' => array('width' => 60, 'alignment' => 'right'));
$sidebar_classes = '';

$gcf = function($a, $b = 60) use(&$gcf) {
    return (int) ($b > 0 ? $gcf($b, $a % $b) : $a);
};

$fraction = function($nominator, $divider = 60) use(&$gcf) {
    return $nominator / ($factor = $gcf($nominator, $divider)) .'-'. $divider / $factor;
};

foreach ($sidebars as $name => $sidebar) {
	if (!$this['widgets']->count($name)) {
        unset($sidebars[$name]);
        continue;
    }

    $columns['main']['width'] -= @$sidebar['width'];
    $sidebar_classes .= " tm-{$name}-".@$sidebar['alignment'];
}

if ($count = count($sidebars)) {
	$sidebar_classes .= ' tm-sidebars-'.$count;
}

$columns += $sidebars;
foreach ($columns as $name => &$column) {

    $column['width']     = isset($column['width']) ? $column['width'] : 0;
    $column['alignment'] = isset($column['alignment']) ? $column['alignment'] : 'left';

    $shift = 0;
    foreach (($column['alignment'] == 'left' ? $columns : array_reverse($columns, true)) as $n => $col) {
        if ($name == $n) break;
        if (@$col['alignment'] != $column['alignment']) {
            $shift += @$col['width'];
        }
    }
    $column['class'] = sprintf('tm-%s uk-width-medium-%s%s', $name, $fraction($column['width']), $shift ? ' uk-'.($column['alignment'] == 'left' ? 'pull' : 'push').'-'.$fraction($shift) : '');
}


/*
 * Add grid classes
 */
$positions = array_keys($config->get('grid', array()));
$displays  = array('small', 'medium', 'large');
$grid_classes = array();
$display_classes = array();
foreach ($positions as $position) {

    $grid_classes[$position] = array();
    $grid_classes[$position][] = "tm-{$position} uk-grid";
    $display_classes[$position][] = '';

    if ($this['config']->get("grid.{$position}.divider", false)) {
        $grid_classes[$position][] = 'uk-grid-divider';
    }

    $widgets = $this['widgets']->load($position);

    foreach($displays as $display) {
        if (!array_filter($widgets, function($widget) use ($config, $display) { return (bool) $config->get("widgets.{$widget->id}.display.{$display}", true); })) {
            $display_classes[$position][] = "uk-hidden-{$display}";
        }
    }

    $display_classes[$position] = implode(" ", $display_classes[$position]);
    $grid_classes[$position] = implode(" ", $grid_classes[$position]);

}

/*
 * Add Youtube section bg
 */
$positions = array_keys($config->get('section_bg', array()));
$section_attr = array();
$section_bg_classes = array();

foreach ($positions as $position) {

	$section_attr[$position] = array();
    $section_bg_classes[$position] = array();

	if ($this['config']->get("section_bg.{$position}.youtube_bg", false)) {
        $section_bg_classes[$position][] = ' tm-youtube-player';
    }
	
	if ($this['config']->get("section_bg.{$position}.youtube_bg", false) )
	{
		$section_attr[$position][] = ' 
			data-quality="' . ($this['config']->get("section_bg.{$position}.quality_youtube_bg")) . '" 
			data-blur="' . ($this['config']->get("section_bg.{$position}.blur_youtube_bg")) . '"
			data-sepia="' . ($this['config']->get("section_bg.{$position}.sepia_youtube_bg")) . '" 
			data-mute="' . ($this['config']->get("section_bg.{$position}.mute_youtube_bg")) . '" 
			data-volume="' . ($this['config']->get("section_bg.{$position}.vol_youtube_bg")) . '" 
			data-video="https://youtu.be/' . ($this['config']->get("section_bg.{$position}.youtube_bg")) . '" 
			style="height: 600px;"
		';
	}

    $widgets = $this['widgets']->load($position);
	
	$section_attr[$position] = implode(" ", $section_attr[$position]);
    $section_bg_classes[$position] = implode(" ", $section_bg_classes[$position]);

}

$design  = '';
if ($this['config']->get('design_branding', true)) {
	$design = 'PGJyIC8+RGVzaWduZWQgYnkgPGEgdGFyZ2V0PSJfYmxhbmsiIGhyZWY9Imh0dHA6Ly93d3cuM2QtaG9iYnktYXJ0LmRlLyIgdGl0bGU9Ikpvb21sYSBUZW1wbGF0ZXMgYW5kIG11Y2ggbW9yZS4uLiI+M2QtaG9iYnktYXJ0LmRlPC9hPg==';
}
	
/*
 * sticky navbar settings
 */
$sticky_navbar  = '';
if ($this['config']->get('sticky_navbar', 0)) {
    $sticky_navbar = 'data-uk-sticky="{media: 768, top:-200, animation: \'' . $this['config']->get("sticky_navbar_animation") . '\'}"';
}


/*
 * Add body classes
 */
$body_classes  = $sidebar_classes;
$body_classes .= $this['system']->isBlog() ? ' tm-isblog' : ' tm-noblog';
$body_classes .= $this['config']->get('featured_articles') ? ' tm-featured-articles' : '';
$body_classes .= $this['config']->get("youtube_bg", true) ? ' tm-youtube-player-body' : '';
$body_classes .= ' '.$config->get('page_class');

$config->set('body_classes', trim($body_classes));


$body_config = array();
$body_config['featuredarticles'] = (int) $config->get('featured_articles', 0);

/*
 * Add social buttons
 */
if ($this['config']->get('twitter', 0) || $this['config']->get('plusone', 0) || $this['config']->get('facebook', 0) || $this['config']->get('linkedin', 0) || $this['config']->get('whatsapp', 0)) :
	$this['asset']->addFile('js', 'js:social.js');
	$this['asset']->addFile('js', 'js:theme.social.js');
endif;
if ($this['config']->get('twitter', 0)) :
	$body_config['twitter']  = (int) $config->get('twitter', 0);
endif;
if ($this['config']->get('plusone', 0)) :
	$body_config['plusone']  = (int) $config->get('plusone', 0);
endif;
if ($this['config']->get('facebook', 0)) :
	$body_config['facebook']  = (int) $config->get('facebook', 0);
endif;
if ($this['config']->get('linkedin', 0)) :
	$body_config['linkedin']  = (int) $config->get('linkedin', 0);
endif;
if ($this['config']->get('whatsapp', 0)) :
	$body_config['whatsapp']  = (int) $config->get('whatsapp', 0);
endif;

$body_config['style']    = $config->get('style');

$config->set('body_config', json_encode($body_config));


/*
 * Add js, css
 */

// add css
$this['asset']->addFile('css', 'css:theme.css');
$this['asset']->addFile('css', 'css:custom.css');

// add scripts
$this['asset']->addFile('js', 'js:uikit.js');

// autocomplete.js
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/autocomplete.js');
// search.js
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/search.js');
// tooltip.js
$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/tooltip.js');

// sticky navbar
if ($this['config']->get('sticky_navbar', 0)) :
	$this['asset']->addFile('js', 'warp:vendor/uikit/js/components/sticky.js');
endif;

$this['asset']->addFile('js', 'js:theme.js');

// internet explorer
if ($this['useragent']->browser() == 'msie') {
	$head[] = sprintf('<!--[if IE 8]><link rel="stylesheet" href="%s"><![endif]-->', $this['path']->url('css:ie8.css'));
    $head[] = sprintf('<!--[if lte IE 8]><script src="%s"></script><![endif]-->', $this['path']->url('js:html5.js'));
}

if (isset($head)) {
	$this['template']->set('head', implode("\n", $head));
}