<?php
/**
* @package		ui-TopStyle
* @author		Stephan W., http://www.3d-hobby-art.de
* @copyright	Copyright (C) Stephan W., http://www.3d-hobby-art.de
* @license		http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// get theme configuration
include($this['path']->path('layouts:theme.config.php'));

$app			= JFactory::getApplication();
$pathimg		= JURI::base(true).'/templates/'.$app->getTemplate().'/images/';

?>
<!DOCTYPE HTML>
<html lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>"  data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>

<head>
<?php echo $this['template']->render('head'); ?>
</head>

<body class="<?php echo $this['config']->get('body_classes'); ?>">

<div id="tm-wrapper">
	<?php if ($this['widgets']->count('toolbar-l + toolbar-r + menu + search + logo + headerbar')) : ?>
	
		<div class="uk-container uk-container-center uk-hidden-small" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
		
			<?php if ($this['widgets']->count('toolbar-l + toolbar-r')) : ?>
				<div class="tm-toolbar uk-clearfix">

					<?php if ($this['widgets']->count('toolbar-l')) : ?>
					<div class="uk-float-left"><?php echo $this['widgets']->render('toolbar-l'); ?></div>
					<?php endif; ?>

					<?php if ($this['widgets']->count('toolbar-r')) : ?>
					<div class="uk-float-right"><?php echo $this['widgets']->render('toolbar-r'); ?></div>
					<?php endif; ?>

				</div>
			<?php endif; ?>

			<?php if ($this['widgets']->count('logo + headerbar')) : ?>
				<div class="tm-headerbar uk-clearfix">

					<?php if ($this['widgets']->count('logo')) : ?>
					<a class="tm-logo" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo'); ?></a>
					<?php endif; ?>

					<?php echo $this['widgets']->render('headerbar'); ?>

				</div>
			<?php endif; ?>
		</div>

		<?php if ($this['widgets']->count('menu + search')) : ?>
			<nav class="tm-navbar uk-navbar" <?php echo $sticky_navbar; ?>>
                <div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>

					<?php if ($this['widgets']->count('menu')) : ?>
					<?php echo $this['widgets']->render('menu'); ?>
					<?php endif; ?>

					<?php if ($this['widgets']->count('offcanvas')) : ?>
					<a href="#offcanvas" class="uk-navbar-toggle uk-visible-small" data-uk-offcanvas></a>
					<?php endif; ?>

					<?php if ($this['widgets']->count('search')) : ?>
					<div class="uk-navbar-flip">
						<div class="uk-navbar-content uk-hidden-small"><?php echo $this['widgets']->render('search'); ?></div>
					</div>
					<?php endif; ?>

					<?php if ($this['widgets']->count('logo-small')) : ?>
					<div class="uk-navbar-content uk-navbar-center uk-visible-small"><a class="tm-logo-small" href="<?php echo $this['config']->get('site_url'); ?>"><?php echo $this['widgets']->render('logo-small'); ?></a></div>
					<?php endif; ?>
				</div>
			</nav>
		<?php endif; ?>
		
	<?php endif; ?>
	
		<?php if ($this['config']->get('system_output', true)) : ?>
			<?php if ($this['widgets']->count('breadcrumbs')) : ?>
				<section id="breadcrumbs" class="uk-block <?php echo $this['config']->get('blocks.breadcrumbs.layout'); ?> <?php echo $this['config']->get('blocks.breadcrumbs.bg-color'); ?> <?php echo $this['config']->get('blocks.breadcrumbs.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<?php echo $this['widgets']->render('breadcrumbs'); ?>
					</div>
				<?php if ($this['config']->get('blocks.breadcrumbs.overlay', true)) : ?>
					<div class="tm-breadcrumbs-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.breadcrumbs.overlay'); ?>) center center <?php if ($this['config']->get('blocks.breadcrumbs.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.breadcrumbs.overlay_fixed', true)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
				<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php if ($this['widgets']->count('top-a')) : ?>
			<?php if ($this['config']->get('section_bg.top-a.youtube_bg', true)) : ?>
				<section id="tm-top-a" class="<?php echo $section_bg_classes['top-a']; ?> <?php echo $this['config']->get('blocks.top-a.layout'); ?> <?php echo $this['config']->get('blocks.top-a.bg-color'); ?> <?php echo $this['config']->get('blocks.top-a.contrast'); ?>"<?php echo $section_attr['top-a']; ?>>
					<div class="tm-vertical-align-middle">
						<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>	
							<div class="<?php echo $grid_classes['top-a']; echo $display_classes['top-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
								<?php echo $this['widgets']->render('top-a', array('layout'=>$this['config']->get('grid.top-a.layout'))); ?>
							</div>
						</div>
					</div>
				</section>
			<?php else : ?>
				<section id="tm-top-a" class="uk-block <?php echo $this['config']->get('blocks.top-a.layout'); ?> <?php echo $this['config']->get('blocks.top-a.bg-color'); ?> <?php echo $this['config']->get('blocks.top-a.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<div class="<?php echo $grid_classes['top-a']; echo $display_classes['top-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-a', array('layout'=>$this['config']->get('grid.top-a.layout'))); ?></div>
					</div>
					<?php if ($this['config']->get('blocks.top-a.overlay', true)) : ?>
						<div class="tm-top-a-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.top-a.overlay'); ?>) center center <?php if ($this['config']->get('blocks.top-a.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.top-a.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
					<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>
		
		<?php if ($this['widgets']->count('top-b')) : ?>
			<?php if ($this['config']->get('section_bg.top-b.youtube_bg', true)) : ?>
				<section id="tm-top-b" class="<?php echo $section_bg_classes['top-b']; ?> <?php echo $this['config']->get('blocks.top-b.layout'); ?> <?php echo $this['config']->get('blocks.top-b.bg-color'); ?> <?php echo $this['config']->get('blocks.top-b.contrast'); ?>"<?php echo $section_attr['top-b']; ?>>
					<div class="tm-vertical-align-middle">
						<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>	
							<div class="<?php echo $grid_classes['top-b']; echo $display_classes['top-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
								<?php echo $this['widgets']->render('top-b', array('layout'=>$this['config']->get('grid.top-b.layout'))); ?>
							</div>
						</div>
					</div>
				</section>
			<?php else : ?>
				<section id="tm-top-b" class="uk-block <?php echo $this['config']->get('blocks.top-b.layout'); ?> <?php echo $this['config']->get('blocks.top-b.bg-color'); ?> <?php echo $this['config']->get('blocks.top-b.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<div class="<?php echo $grid_classes['top-b']; echo $display_classes['top-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-b', array('layout'=>$this['config']->get('grid.top-b.layout'))); ?></div>
					</div>
				<?php if ($this['config']->get('blocks.top-b.overlay', true)) : ?>
					<div class="tm-top-b-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.top-b.overlay'); ?>) center center <?php if ($this['config']->get('blocks.top-b.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.top-b.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
				<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>


		<?php if ($this['widgets']->count('main-top + main-bottom + sidebar-a + sidebar-b') || $this['config']->get('system_output', true)) : ?>
			<section id="tm-middle" class="uk-block <?php echo $this['config']->get('blocks.middle.layout'); ?> <?php echo $this['config']->get('blocks.middle.bg-color'); ?> <?php echo $this['config']->get('blocks.middle.contrast'); ?>">
				<div class="uk-container uk-container-center <?php if ($this['config']->get('featured_articles', true)) : ?>tm-container-100<?php endif; ?>" <?php if ($this['config']->get('maxwidth', true) && ! $this['config']->get('featured_articles', false)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
					<div class="tm-middle uk-grid" data-uk-grid-match data-uk-grid-margin>

						<?php if ($this['widgets']->count('main-top + main-bottom') || $this['config']->get('system_output', true)) : ?>
						<div class="<?php echo $columns['main']['class'] ?>">

							<?php if ($this['widgets']->count('main-top')) : ?>
							<section id="tm-main-top" class="<?php echo $grid_classes['main-top']; echo $display_classes['main-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-top', array('layout'=>$this['config']->get('grid.main-top.layout'))); ?></section>
							<?php endif; ?>

							<?php if ($this['config']->get('system_output', true)) : ?>
							<main id="tm-content" class="tm-content">

								<?php echo $this['template']->render('content'); ?>

							</main>
							<?php endif; ?>

							<?php if ($this['widgets']->count('main-bottom')) : ?>
							<section id="tm-main-bottom" class="<?php echo $grid_classes['main-bottom']; echo $display_classes['main-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-bottom', array('layout'=>$this['config']->get('grid.main-bottom.layout'))); ?></section>
							<?php endif; ?>

						</div>
						<?php endif; ?>

						<?php foreach($columns as $name => &$column) : ?>
						<?php if ($name != 'main' && $this['widgets']->count($name)) : ?>
						<aside class="<?php echo $column['class'] ?>"><?php echo $this['widgets']->render($name) ?></aside>
						<?php endif ?>
						<?php endforeach ?>

					</div>
				</div>
			<?php if ($this['config']->get('blocks.middle.overlay', true)) : ?>
				<div class="tm-middle-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.middle.overlay'); ?>) center center <?php if ($this['config']->get('blocks.middle.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.middle.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
			<?php endif; ?>
			</section>
		<?php endif; ?>


		<?php if ($this['widgets']->count('bottom-a')) : ?>
			<?php if ($this['config']->get('section_bg.bottom-a.youtube_bg', true)) : ?>
				<section id="tm-bottom-a" class="<?php echo $section_bg_classes['bottom-a']; ?> <?php echo $this['config']->get('blocks.bottom-a.layout'); ?> <?php echo $this['config']->get('blocks.bottom-a.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-a.contrast'); ?>"<?php echo $section_attr['bottom-a']; ?>>
					<div class="tm-vertical-align-middle">
						<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>	
							<div class="<?php echo $grid_classes['bottom-a']; echo $display_classes['bottom-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
								<?php echo $this['widgets']->render('bottom-a', array('layout'=>$this['config']->get('grid.bottom-a.layout'))); ?>
							</div>
						</div>
					</div>
				</section>
			<?php else : ?>
				<section id="tm-bottom-a" class="uk-block <?php echo $this['config']->get('blocks.bottom-a.layout'); ?> <?php echo $this['config']->get('blocks.bottom-a.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-a.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<div class="<?php echo $grid_classes['bottom-a']; echo $display_classes['bottom-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-a', array('layout'=>$this['config']->get('grid.bottom-a.layout'))); ?></div>
					</div>
					<?php if ($this['config']->get('blocks.bottom-a.overlay', true)) : ?>
						<div class="tm-bottom-a-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.bottom-a.overlay'); ?>) center center <?php if ($this['config']->get('blocks.bottom-a.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.bottom-a.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
					<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>
		

		<?php if ($this['widgets']->count('bottom-b')) : ?>
			<?php if ($this['config']->get('section_bg.bottom-b.youtube_bg', true)) : ?>
				<section id="tm-bottom-b" class="<?php echo $section_bg_classes['bottom-b']; ?> <?php echo $this['config']->get('blocks.bottom-b.layout'); ?> <?php echo $this['config']->get('blocks.bottom-b.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-b.contrast'); ?>"<?php echo $section_attr['bottom-b']; ?>>
					<div class="tm-vertical-align-middle">
						<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>	
							<div class="<?php echo $grid_classes['bottom-b']; echo $display_classes['bottom-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
								<?php echo $this['widgets']->render('bottom-b', array('layout'=>$this['config']->get('grid.bottom-b.layout'))); ?>
							</div>
						</div>
					</div>
				</section>
			<?php else : ?>
				<section id="tm-bottom-b" class="uk-block <?php echo $this['config']->get('blocks.bottom-b.layout'); ?> <?php echo $this['config']->get('blocks.bottom-b.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-b.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<div class="<?php echo $grid_classes['bottom-b']; echo $display_classes['bottom-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-b', array('layout'=>$this['config']->get('grid.bottom-b.layout'))); ?></div>
					</div>
					<?php if ($this['config']->get('blocks.bottom-b.overlay', true)) : ?>
						<div class="tm-bottom-b-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.bottom-b.overlay'); ?>) center center <?php if ($this['config']->get('blocks.bottom-b.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.bottom-b.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
					<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>		
		
		
		<?php if ($this['widgets']->count('bottom-c')) : ?>
			<?php if ($this['config']->get('section_bg.bottom-c.youtube_bg', true)) : ?>
				<section id="tm-bottom-c" class="<?php echo $section_bg_classes['bottom-c']; ?> <?php echo $this['config']->get('blocks.bottom-c.layout'); ?> <?php echo $this['config']->get('blocks.bottom-c.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-c.contrast'); ?>"<?php echo $section_attr['bottom-c']; ?>>
					<div class="tm-vertical-align-middle">
						<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>	
							<div class="<?php echo $grid_classes['bottom-c']; echo $display_classes['bottom-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
								<?php echo $this['widgets']->render('bottom-c', array('layout'=>$this['config']->get('grid.bottom-c.layout'))); ?>
							</div>
						</div>
					</div>
				</section>
			<?php else : ?>
				<section id="tm-bottom-c" class="uk-block <?php echo $this['config']->get('blocks.bottom-c.layout'); ?> <?php echo $this['config']->get('blocks.bottom-c.bg-color'); ?> <?php echo $this['config']->get('blocks.bottom-c.contrast'); ?>">
					<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
						<div class="<?php echo $grid_classes['bottom-c']; echo $display_classes['bottom-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-c', array('layout'=>$this['config']->get('grid.bottom-c.layout'))); ?></div>
					</div>
					<?php if ($this['config']->get('blocks.bottom-c.overlay', true)) : ?>
						<div class="tm-bottom-c-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.bottom-c.overlay'); ?>) center center <?php if ($this['config']->get('blocks.bottom-c.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.bottom-c.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
					<?php endif; ?>
				</section>
			<?php endif; ?>
		<?php endif; ?>



		<?php if ($this['widgets']->count('footer') || $this['config']->get('warp_branding', true)  || $this['config']->get('design_branding', true)) : ?>
			<section id="tm-footer" class="uk-block <?php echo $this['config']->get('blocks.footer.layout'); ?> <?php echo $this['config']->get('blocks.footer.bg-color'); ?> <?php echo $this['config']->get('blocks.footer.contrast'); ?>">
				<div class="uk-container uk-container-center" <?php if ($this['config']->get('maxwidth', true)) : ?>style="max-width:<?php echo $this['config']->get('maxwidth') ?>px"<?php endif; ?>>
					<footer class="tm-footer">

						<?php echo $this['widgets']->render('footer');?>
						<?php $this->output('warp_branding');?>
						<?php echo base64_decode($design);?>
						
					</footer>
				</div>
				<?php if ($this['config']->get('blocks.footer.overlay', true)) : ?>
					<div class="tm-footer-overlay uk-visible-large" style="background: url(<?php echo $pathimg; ?><?php echo $this['config']->get('blocks.footer.overlay'); ?>) center center <?php if ($this['config']->get('blocks.footer.overlay_repeat', 0)) { ?>repeat<?php } else { ?>no-repeat<?php } ?>; <?php if ($this['config']->get('blocks.footer.overlay_fixed', 0)) : ?>background-attachment: fixed;<?php endif; ?>"></div>
				<?php endif; ?>
			</section>
			
			<?php if ($this['widgets']->count('debug')) : ?>
				<div class="uk-block">
					<?php echo $this['widgets']->render('debug');?>
				</div>
			<?php endif; ?>
			
			<?php if ($this['config']->get('totop_scroller', true)) : ?>
				<a class="tm-totop-scroller" data-uk-smooth-scroll href="#"></a>
			<?php endif; ?>
		<?php endif; ?>
</div>

	<?php if ($this['config']->get("youtube_bg", true)) : ?>
		<script src="<?php echo JURI::root() . 'templates/'.$app->getTemplate().'/js/pl_youtube_bg_min.js'; ?>" type="text/javascript"></script>
	<?php endif; ?>

	<?php echo $this->render('footer'); ?>

	<?php if ($this['widgets']->count('offcanvas')) : ?>
	<div id="offcanvas" class="uk-offcanvas">
		<div class="uk-offcanvas-bar"><?php echo $this['widgets']->render('offcanvas'); ?></div>
	</div>
	<?php endif; ?>

</body>
</html>